//Copyright 2012-2013 Adobe Systems Incorporated.  All rights reserved.

var helpDoc = MM.HELP_jQueryProgressbar;			

var PROGRESSBAR_ID;
var VALUE_INPUT;
var MAX_INPUT;
var DISABLED_CHECK;
var ANIMATED_CHECK;


// ********************* API FUNCTIONS ***************************

//--------------------------------------------------------------------
// FUNCTION:
//   canInspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document changes to decide whether
//   or not this property inspector should be displayed.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   true if the currently selected node is a Progressbar element,
//   false if it is not.
//--------------------------------------------------------------------

function canInspectSelection() 
{
	var bCanInspectSelection = false;
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if ( !selectedNode || !selectedNode.getTranslatedAttribute )
		return false;
	
	var attr = selectedNode.getTranslatedAttribute('progressbar');
  
	if ( attr && attr.length > 0 )
	{

		bCanInspectSelection = true;
	
		// If the widget manager is out of sync, run the translator
		var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
		
		if (!widgetMgr)
			return;
	
		if ( !widgetMgr.getWidget('progressbar', selectedNode.id ) )
		{ 
			dom.runTranslator("jQuery Widget");

			if ( !widgetMgr.getWidget('progressbar', selectedNode.id ) )
		{ 
			// Running the translator failed to create a design time object
			// for this widget. Either caInspectSelection() was called in the
			// middle of an edit operation, which prevents the translator from
			// running right now, or an error occurred during the translation.

			bCanInspectSelection = false;
		}
		}  
	}

	return bCanInspectSelection;
}

//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This is an internal utility function that searches through the
//   Property Inspector document to find all of the UI controls we
//   will programatically manipulate, and stores handles to them in
//   global variables which are used in some of the other functions
//   for this Property Inspector.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function initializeUI() 
{
	PROGRESSBAR_ID = document.getElementById("idInput");	
	VALUE_INPUT = document.getElementById("valueInput")
	MAX_INPUT = document.getElementById("maxInput")
	DISABLED_CHECK = document.getElementById("disabledCheck");
	ANIMATED_CHECK = document.getElementById("animatedCheck");
}

//--------------------------------------------------------------------
// FUNCTION:
//   inspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document has changed and it has
//   been decided that this Property Inspector should be displayed.
//   This function syncs up the Property Inspector UI with the
//   widget's design-time object so that it accurately reflects
//   what is in the widget HTML markup and its JS constructor.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function inspectSelection() 
{
	dw.logEvent(UT_JQUERY_PROGRESSBAR, UT_JQUERY_PROGRESSBAR_INSPECT);

	// Call initializeUI() here; it's how the global variables get
	// initialized. The onLoad event on the body tag is never triggered
	// in inspectors.
	initializeUI();

	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if (!canInspectSelection())
		return;
		
	var divId = selectedNode.id;
	// Update the ID field in the PI.
	PROGRESSBAR_ID.value = divId;	
	
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  
	if (!widgetMgr)
		return;
	
	var progressbar = widgetMgr.getWidget('progressbar', divId);
	
	if (!progressbar)
	{
		return;
	}
	
	VALUE_INPUT.value = progressbar.getValue();
	MAX_INPUT.value = progressbar.getMaxValue();
	DISABLED_CHECK.checked = progressbar.getDisabledValue();
	ANIMATED_CHECK.checked = progressbar.getAnimatedValue();
}

//--------------------------------------------------------------------
// FUNCTION:
//   updateTag
//
// DESCRIPTION:
//   This function handles all of the user actions triggered by the
//   user from the Propery Inspector controls.
//
// ARGUMENTS:
//  action - string - The name of the action to perform.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------
function updateTag(action)
{
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	if (!canInspectSelection())
		return;
  
	var divId = selectedNode.id;
  
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
	var progressbar = widgetMgr.getWidget('progressbar', divId );
	if ( !progressbar )
		return;
    
	if (action) 
	{
		switch (action)
		{
			case "id":
			{
				// Validate the new id.
				var newId = PROGRESSBAR_ID.value;
				if ( newId == divId )
				  return; // Nothing to change.
				
				if ( newId.length == 0 )
				{
				  alert(dw.loadString("jquery/widget/alert/need unique id"));
				  return;
				}
				
				if ( dom.getElementById(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id already exists"));
				  return;
				}
				
				if ( !dwscripts.isValidID(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id is invalid"));
				  return;
				}
				
				// Update the constructor.
				progressbar.updateWidgetId(newId);

				// Update the WidgetManager for the new ID.
				widgetMgr.setWidget('progressbar', newId, progressbar );
			}
			break;
			
			case 'setValue':
			{
				progressbar.setValue(VALUE_INPUT.value);
			}
			break;
			case 'setMax':
			{
				progressbar.setMaxValue(MAX_INPUT.value);
			}
			break;
			case 'setDisabled':
			{
				progressbar.setDisabledValue(DISABLED_CHECK.checked);
			}
			break;
			case 'setAnimated':
			{
				progressbar.setAnimatedValue(ANIMATED_CHECK.checked);
			}
			break;
		}
		
   }

	// All these edits modify the Progressbar. We need to recreate the JS Object to reflect those changes.
	progressbar.refresh();

	// Make sure selection stays on the input.
	dom.setSelectedNode(selectedNode); 
	inspectSelection();
}
